import Utilities.waveform_creator as wc
import Utilities.gui_creator as gc
import Utilities.plot_creator as pc


def calculate_plot_waveform():
    
    speed_string = gc.get_control_string(var_ent_1)
    height_string = gc.get_control_string(var_ent_2)

    v = float(speed_string)
    h = float(height_string)

    thetas = list(range(0, +91))
    ranges,max_angle = wc.projectile(thetas, v, h)
    
    pc.update_plot(ax, canvas, thetas, ranges, label_x, label_y,
                   marker='-')
    lbl_2.configure(text=str(max_angle))

    return

title = 'Projectile Range'
label_x, label_y = 'Launch Angle(deg)','Range (m)'

root = gc.create_window(title)
control_box,right_frame = gc.create_frames(root)

var_ent_1 = gc.create_control(control_box, 'Launch Speed (m/s)')
var_ent_2 = gc.create_control(control_box, 'Launch Height (m)')
lbl_2 = gc.create_indicator(control_box, 'Angle for Maximum Range (deg)')

ax,canvas = pc.create_plot(right_frame)
pc.update_plot(ax, canvas, [], [], label_x, label_y)

gc.action_button(control_box, label='Submit',
                 action= calculate_plot_waveform)

root.mainloop()
